function A = doNanValues(matrix,perc)
    % Get the size of the matrix
    dims = size(matrix);
    numRows = dims(1); % Number of rows in the first dimension
    numCols = dims(2); % Number of columns in the second dimension
    
    % Generate a multi-dimensional index structure for all higher dimensions
    higherDims = dims(3:end); % Remaining dimensions beyond the first two
    totalCombinations = prod(higherDims); % Total number of slices
    
    % Loop through each combination of higher dimensions
    for idx = 1:totalCombinations
        % Convert linear index to subscript indices
        [subscripts{1:numel(higherDims)}] = ind2sub(higherDims, idx);
        
        % Loop through each row in the first dimension
        for row = 1:numRows
            % Randomly select 30% of the columns in the current row
            numToReplace = round((perc/100) * numCols); % Calculate 30% of columns
            nanIndices = randperm(numCols, numToReplace); % Random selection
            
            % Construct the full index for assignment
            fullIndex = [{row}, nanIndices, subscripts];
            
            % Set the selected elements to NaN
            A(fullIndex{:}) = NaN;
        end
    end
    
    % Display the modified matrix
%     disp(A);
end
